rm(list=ls())
library(foreign)
library(graphics)
library(stats)
library(plyr)
library(reshape2)
library(lme4)
library(ggplot2)
library(lmerTest)
library(Hmisc)
##############necessary datasets **********
MF7<-as.data.frame(read.spss("I:/ESS/ESS/round7/ESS7e02.sav", use.value.labels = FALSE))
IN7<-as.data.frame(read.spss("I:/ESS/ESS/round7/ESS7INTe02.sav", use.value.labels = FALSE))
TI7<-as.data.frame(read.spss("I:/ESS/ESS/round7/ESS7TIMEe01.sav", use.value.labels = FALSE))
names(MF7) <- toupper(names(MF7))
names(IN7) <- toupper(names(IN7))
names(TI7) <- toupper(names(TI7))
table (IN7$CNTRY)

 #select only countries with module measurements
TI<-TI7[which(TI7$CNTRY %in% c("AT","BE","DK","EE","FI","FR","HU","IE","DE","NL","NO","SI","SE","CH","GB")),]
TISI<-TI7[which(TI7$CNTRY %in% c("SI")),]
TISI<-TISI[order(TISI$INWTM),]
#create unique id across cntrie

TI$ID.IND<-paste("I",TI$CNTRY,TI$ESSROUND*100000000+TI$IDNO,sep="")
TI$CNTRY<-factor(TI$CNTRY)

TI$Amissings<-ifelse(is.na(TI$AINWTM),1,0)
TI$Bmissings<-ifelse(is.na(TI$BINWTM),1,0)
TI$Cmissings<-ifelse(is.na(TI$CINWTM),1,0)
TI$Dmissings<-ifelse(is.na(TI$DINWTM),1,0)
TI$Emissings<-ifelse(is.na(TI$EINWTM),1,0)
TI$Fmissings<-ifelse(is.na(TI$FINWTM),1,0)
TI$missings<-ifelse(is.na(TI$INWTM),1,0)

test<-TI[,c("CNTRY","Amissings","Bmissings","Cmissings","Dmissings","Emissings","Fmissings", "missings")]
TImissings1<-aggregate.data.frame(test, by=list(test$CNTRY),FUN=mean,na.rm=T)


quantile(TI$BINWTM,na.rm=T,prob=seq(0,1,length=41))
quantile(TI$CINWTM,na.rm=T,prob=seq(0,1,length=41))
quantile(TI$DINWTM,na.rm=T,prob=seq(0,1,length=41))
quantile(TI$EINWTM,na.rm=T,prob=seq(0,1,length=41))
quantile(TI$FINWTM,na.rm=T,prob=seq(0,1,length=41))
#put everything to NA if the full length is unreasonable
TI$INWTM[TI$INWTM<20 | TI$INWTM>180]<-NA
TI$AINWTM[TI$AINWTM<1 | TI$AINWTM>20 | is.na(TI$INWTM)]<-NA
TI$BINWTM[TI$BINWTM<4 | TI$BINWTM>45 | is.na(TI$INWTM)]<-NA
TI$CINWTM[TI$CINWTM<2 | TI$CINWTM>25 | is.na(TI$INWTM)]<-NA
TI$DINWTM[TI$DINWTM<3 | TI$DINWTM>30 | is.na(TI$INWTM)]<-NA
TI$EINWTM[TI$EINWTM<3 | TI$EINWTM>30 | is.na(TI$INWTM)]<-NA
TI$FINWTM[TI$FINWTM<5 | TI$FINWTM>60 | is.na(TI$INWTM)]<-NA
#how many missings
TI$Amissings<-ifelse(is.na(TI$AINWTM),1,0)
TI$Bmissings<-ifelse(is.na(TI$BINWTM),1,0)
TI$Cmissings<-ifelse(is.na(TI$CINWTM),1,0)
TI$Dmissings<-ifelse(is.na(TI$DINWTM),1,0)
TI$Emissings<-ifelse(is.na(TI$EINWTM),1,0)
TI$Fmissings<-ifelse(is.na(TI$FINWTM),1,0)
TI$missings<-ifelse(is.na(TI$INWTM),1,0)

test<-TI[,c("CNTRY","Amissings","Bmissings","Cmissings","Dmissings","Emissings","Fmissings", "missings")]
TImissings<-aggregate.data.frame(test, by=list(test$CNTRY),FUN=mean,na.rm=T)

test2<-TI[which(TI$CINWTM<2),]

######################create speed per module######################################

##########calculate the number of applicable question
MF<-MF7[which(MF7$CNTRY %in% c("AT","BE","DK","EE","FI","FR","HU","IE","DE","NL","NO","SI","SE","CH","GB")),]
MF$CNTRY<-factor(MF$CNTRY)
MF$ID.IND<-paste("I",MF$CNTRY,MF$ESSROUND*100000000+MF$IDNO,sep="")
MF$DSCRNA<-ifelse(MF$DSCRNA==1,9,0)
MF$DSHLTNA<-ifelse(MF$DSHLTNA==1,9,0)
MF$MEDTRNA<-ifelse(MF$MEDTRNA==1,9,0)
MF$TRHLTNA<-ifelse(MF$TRHLTNA==1,9,0)
MF$HLTPRNA<-ifelse(MF$HLTPRNA==1,9,0)
MF$HLTPHNA<-ifelse(MF$HLTPHNA==1,9,0)
MF<-merge(MF,TI[,c("ID.IND","AINWTM","BINWTM","CINWTM","DINWTM","EINWTM","FINWTM","INWTM")], by="ID.IND",all.x=T)
test<-merge(MF,PSU[,c("ID.IND","PSU")], by="ID.IND",all.x=T)
test$AREA<-ifelse(is.na(test$PSU),1,test$PSU)
table(test[which(test$CNTRY=="BE"),]$AREA)
MF<-test

#create one array for each module
array.A<-c("TVTOT","TVPOL","PPLTRST","PPLFAIR","PPLHLP")
array.B<-c("POLINTR","PSPPSGV","ACTROLG","PSPPIPL","CPTPPOL","PTCPPLT","ETAPAPL","TRSTPRL","TRSTLGL","TRSTPLC","TRSTPLT",
           "TRSTPRT","TRSTEP","TRSTUN","VOTE","PRTVTBAT","PRTVTCBE","PRTVTECH","PRTVEDE1","PRTVEDE2","PRTVTCDK",
           "PRTVTEEE","PRTVTCFI","PRTVTCFR","PRTVTAGB","PRTVTEHU","PRTVTAIE",
           "PRTVTFNL","PRTVTBNO","PRTVTBSE","PRTVTESI","CONTPLT","WRKPRTY","WRKORG","BADGE",
           "SGNPTIT","PBLDMN","BCTPRD","CLSPRTY","PRTCLCAT","PRTCLECH" ,"PRTCLCBE","PRTCLEDE","PRTCLCDK",
           "PRTCLEEE","PRTCLCFI","PRTCLCFR","PRTCLAGB","PRTCLEHU","PRTCLAIE","PRTCLBNO",
           "PRTCLBSE","PRTCLESI","PRTDGCL","LRSCALE","STFLIFE","STFECO","STFGOV","STFDEM","STFEDU","STFHLTH","GINCDIF"
           ,"FREEHMS","EUFTF","IMSMETN","IMDFETN","EIMPCNT","IMPCNTR","IMBGECO","IMUECLT","IMWBCNT")
array.C<-c("HAPPY","SCLMEET","INPRDSC","SCLACT","CRMVCT","AESFDRK","HEALTH","HLTHHMP","RLGDNM","RLGBLGE","RLGDNME","RLGDGR",
           "RLGATND","PRAY", "DSCRGRP","DSCRNA","CTZCNTR","CTZSHIPC","BRNCNTR","CNTBRTHC","LIVECNTA","LNGHOM1","LNGHOM2",
           "BLGETMG","FACNTR","FBRNCNTB","MOCNTR","MBRNCNTB","MMBRN")
array.D<-c("QFIMEDU","QFIMLNG","QFIMCHR","QFIMWHT","QFIMWSK","QFIMCMT","IMTCJOB","IMBLECO","IMWBCRM","IMDETBS","IMDETMR",
           "ACETALV","PPLSTRD","LWDSCWP","GVRFGAP","NOIMBRO","ICBRNCT","GVTRIMG","RLGUEIM","DFEGCF","DFEGCON","DFEGHBG",
           "FCLCNTR","SMEGBLI","SMEGBHW","SMCTMBE","ALJEWLV","ALMUSLV","ALGYPLV","ADMAIMG","ALPFPE","ALPFPNE","ALLBPE",
           "ALLBPNE")
array.E<-c("ETFRUIT","EATVEG","DOSPRT","CGTSMKE","CGTSDAY","ALCFREQ","ALCWKDY","ALCWKND","ALCBNGE","HEIGHT","WEIGHT",
           "DSHLTNA","MEDTRUN","MEDTRNA","HLPFMLY","HLPFMHR","TRHLTNA","FLTDPR","FLTEEFF","SLPRL","WRHPP","FLTLNL",
           "ENJLF","FLTSD","CLDGNG","HLTPRNA","HLTPHNA","HLTPRCA","CNFPPLH","FNSDFML")

array.F<-c("HHMMB" , "GNDR",     "GNDR2",    "GNDR3" ,   "GNDR4","GNDR5","GNDR6" ,   "GNDR7"   , "GNDR8" ,   "GNDR9"  ,  "GNDR10"  , "GNDR11" ,  "GNDR12"  , "GNDR13"  ,"AGEA","YRBRN",   
           "YRBRN2", "YRBRN3","YRBRN4", "YRBRN5", "YRBRN6", "YRBRN7", "YRBRN8" , "YRBRN9" ,"YRBRN10", "YRBRN11", "YRBRN12" ,"YRBRN13" ,
           "RSHIPA2" ,"RSHIPA3" , "RSHIPA4","RSHIPA5", "RSHIPA6","RSHIPA7", "RSHIPA8","RSHIPA9","RSHIPA10", "RSHIPA11" ,"RSHIPA12",
           "RSHIPA13","ICPART1", "RSHPSTS","RSHPSFI", "LVGPTNEA","DVRCDEVA","ICPART2" ,"ICCOHBT","MARSTS","MARITALB","MARSTFI" ,
           "MARSTIE" , "CHLDHM" , "CHLDHHE","DOMICIL","ANYPACC", "EDULVLB","EISCED", "EDLVEAT" ,"EDLVEBE", "EDLVDCH" ,"EDUADE1" ,
           "EDUDE2" ,  "EDUDE3",   "EDLVDDK",  "EDLVDEE"  ,"EDLVDFI" , "EDLVDFR" , "EDUBGB1", "EDUAGB2" , "EDAGEGB"  ,"EDLVDHU" , "EDLVDIE" ,
           "EDLVENL" , "EDLVDNO"  , "EDLVDSE",  "EDLVDSI" , "EDUYRS",   "PDWRK"  , 
           "EDCTN" ,   "UEMPLA" ,  "UEMPLI"  , "DSBLD"  ,  "RTRD"  ,   "CMSRV" ,   "HSWRK" ,   "DNGOTH"  , "DNGREF" ,  "DNGDK"  ,  "DNGNA"  ,  "ICOMDNG" ,
           "MAINACT"  ,"MNACTIC",  "ICPDWRK",  "CRPDWK" ,  "PDJOBEV",  "PDJOBYR" , "EMPLREL"  ,"EMPLNO",   "WRKCTRA"  ,"ESTSZ" ,   "JBSPV",    "NJBSPV"  ,
           "WKDCORGA", "IORGACT" , "ICWHCT"  , "WKHCT" ,   "WKHTOT","NACER2"  , "TPORGWK"  ,"ISCO08" ,  "WRKAC6M",  "JBEXPVI" , "JBEXPTI" , "JBEXPML" ,
           "JBEXPMC" , "JBEXPNT" , "JBEXPNAP" ,"JBEXPREF", "JBEXPDK" , "JBEXPNA"  ,"JBEXEVL" , "JBEXEVH" , "JBEXEVC" , "JBEXERA" , "JBEXECP" , "JBEXEBS" ,
           "JBEXENT" , "JBEXENAP" ,"JBEXEREF", "JBEXEDK" , "JBEXENA" , "UEMP3M"  , "UEMP12M" , "UEMP5YR" , "MBTRU"  ,  "HINCSRCA" ,"HINCTNTA" ,"HINCFEL" ,
           "ICPART3" , "EDULVLPB", "EISCEDP" , "EDLVPEAT" ,"EDLVPEBE" ,"EDLVPDCH",  "EDUPADE1" ,"EDUPDE2" , "EDUPDE3" ,"EDLVPDDK" ,"EDLVPDEE",
           "EDLVPDFI", "EDLVPDFR" ,"EDUPBGB1" ,"EDUPAGB2", "EDAGEPGB", "EDLVPHU" , "EDLVPDIE" ,  "EDLVPENL",
           "EDLVPDNO", "EDLVPDSE" ,"EDLVPDSI", "PDWRKP" ,  "EDCTNP"  , "UEMPLAP",  "UEMPLIP"  ,"DSBLDP"  , "RTRDP"  , 
           "CMSRVP" ,  "HSWRKP" ,  "DNGOTHP" , "DNGDKP"  , "DNGNAPP" , "DNGREFP" , "DNGNAP" ,  "ICOMDNP" , "MNACTP" ,  "ICPPDWK" , "CRPDWKP" , "ISCO08P", 
           "EMPRELP" , "WKHTOTP" , "EDULVLFB" ,"EISCEDF" , "EDLVFEAT" ,"EDLVFEBE", "EDLVFDCH", "EDLVFDDK" ,"EDUFADE1", "EDUFDE2",  "EDUFDE3" ,
           "EDLVFDEE", "EDLVFDFI" ,"EDLVFDFR", "EDUFBGB1" ,"EDUFAGB2" ,"EDAGEFGB" ,"EDLVFHU" , "EDLVFDIE" ,
           "EDLVFENL" ,"EDLVFDNO", "EDLVFDSE", "EDLVFDSI" ,"EMPRF14" , "OCCF14B" , "EDULVLMB" ,"EISCEDM" , "EDLVMEAT" ,"EDLVMEBE",
           "EDLVMDCH",  "EDUMADE1", "EDUMDE2" , "EDUMDE3" , "EDLVMDDK", "EDLVMDEE" ,"EDLVMDFI", "EDLVMDFR" ,"EDUMBGB1", "EDUMAGB2",
           "EDAGEMGB", "EDLVMHU" , "EDLVMDIE" ,"EDLVMENL" ,"EDLVMDNO" ,"EDLVMDSE", "EDLVMDSI",
           "EMPRM14" , "OCCM14B" , "ATNCRSE" , "ANCTRY1" , "ANCTRY2" , "IPCRTIV" , "IMPRICH" , "IPEQOPT" , "IPSHABT" , "IMPSAFE" , "IMPDIFF" , "IPFRULE" ,
           "IPUDRST" , "IPMODST",  "IPGDTIM" , "IMPFREE" , "IPHLPPL" , "IPSUCES" , "IPSTRGV" , "IPADVNT" , "IPBHPRP"  ,"IPRSPOT" , "IPLYLFR" , "IMPENV" , 
           "IMPTRAD" , "IMPFUN"  )



NA1    <- function(x)     x<-ifelse(is.na(x),1,ifelse(x==9,4,ifelse(x==8,3,ifelse(x==7,2,ifelse(x==6,1,0)))))
NA2    <- function(x)     x<-ifelse(is.na(x),1,ifelse(x==99,4,ifelse(x==88,3,ifelse(x==77,2,ifelse(x==66,1,0)))))
NA3    <- function(x)     x<-ifelse(is.na(x),1,ifelse(x==999,4,ifelse(x==888,3,ifelse(x==777,2,ifelse(x==666,1,0)))))
NA4    <- function(x)     x<-ifelse(is.na(x),1,ifelse(x==9999,4,ifelse(x==8888,3,ifelse(x==7777,2,ifelse(x==6666,1,0)))))
NA5    <- function(x)     x<-ifelse(is.na(x),1,ifelse(x==99999,4,ifelse(x==88888,3,ifelse(x==77777,2,ifelse(x==66666,1,0)))))

fun.0<-function(x) length(which(x==0))#answer
fun.1<-function(x) length(which(x==1))#not applicable
fun.2<-function(x) length(which(x==2))#refusal
fun.3<-function(x) length(which(x==3))#don't know
fun.4<-function(x) length(which(x==4))#no anwer
fun.st<-function(x) (x-mean(x,na.rm=T))/sd(x,na.rm=T)



#module B (module , all questions are applicable)

attach(MF)
lijst<-NULL

for(i in 1:length(array.B)){
  #  for(i in 1:3){
  var<-array.B[[i]]
  print(var) 
  t<-as.data.frame(table(get(var)))
  t$var<-var
  lijst<-rbind(lijst,t)}
detach(MF)
lijst$Freq<-as.numeric(as.character(lijst$Var1))
llijst<-dcast(lijst, var ~ Var1, mean, value.var = 'Freq')
llijst$max <- apply(llijst[,-1],1,max,na.rm=T)

llijst$g<-ifelse(llijst$max <= 9,9,
                 ifelse(llijst$max <= 99,99,
                        ifelse(llijst$max <= 999,999,
                               ifelse(llijst$max <= 9999,9999,99999))))

splits<-split(llijst, llijst$g)
array.1<-as.vector(splits$`9`[,"var"])
array.2<-as.vector(splits$`99`[,"var"])
array.3<-as.vector(splits$`999`[,"var"])
array.4<-as.vector(splits$`9999`[,"var"])
array.5<-as.vector(splits$`99999`[,"var"])
array.all<-c(array.1,array.2,array.3,array.4,array.5)


respondents<-MF

respondents[array.1]<-lapply(respondents[array.1],NA1)
respondents[array.2]<-lapply(respondents[array.2],NA2)
respondents[array.3]<-lapply(respondents[array.3],NA3)
respondents[array.4]<-lapply(respondents[array.4],NA4)
respondents[array.5]<-lapply(respondents[array.5],NA5)

respondents$t0<-apply(respondents[array.all],1, fun.0)
respondents$t1<-apply(respondents[array.all],1, fun.1)
respondents$t2<-apply(respondents[array.all],1, fun.2)
respondents$t3<-apply(respondents[array.all],1, fun.3)
respondents$t4<-apply(respondents[array.all],1, fun.4)
respondents$tt<-respondents$t0+respondents$t1+respondents$t2+respondents$t3+respondents$t4#total numner pf question
respondents$q.elig<-respondents$tt-respondents$t1
respondents$perc.unanswerd<-(respondents$t2+respondents$t3+respondents$t4)/(respondents$tt-respondents$t1)
respondents<-respondents[,c("ID.IND","q.elig","perc.unanswerd")]
min(respondents$q.elig)

MF<-merge(MF,respondents,by="ID.IND")
MF$q.eligB<-MF$q.elig
MF$speedB<-MF$q.eligB/MF$BINWTM
min(MF$q.eligB,na.rm=T)
max(MF$q.eligB,na.rm=T)
MF<-MF[, which(!names(MF) %in% c("q.elig"))]

MF$lspeedB<-log(MF$speedB)
MF$CNTRYplot<-revalue(MF$CNTRY, c("AT"="Austria","BE"="Belgium","DK"="Denmark","EE"="Estonia","FI"="Finland"
                                  ,"FR"="France","HU"="Hungary","IE"="Ireland","DE"="Germany","NL"="The Nederlands","NO"="Norway"
                                  ,"SI"="Slovenia","SE"="Sweden","CH"="Switzerland","GB"="The United Kingdom"))
ggplot(data=MF,aes(x=speedB))+
  geom_histogram()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("Distribution Speed over module B per country")
ggplot(data=MF,aes(x=lspeedB))+
  geom_histogram()+
  facet_wrap(~CNTRYplot,ncol=5)+ggtitle("Distribution LogSpeed over module B per country")

#module C 

attach(MF)
lijst<-NULL

for(i in 1:length(array.C)){
  #  for(i in 1:3){
  var<-array.C[[i]]
  print(var) 
  t<-as.data.frame(table(get(var)))
  t$var<-var
  lijst<-rbind(lijst,t)}
detach(MF)
lijst$Freq<-as.numeric(as.character(lijst$Var1))
llijst<-dcast(lijst, var ~ Var1, mean, value.var = 'Freq')
llijst$max <- apply(llijst[,-1],1,max,na.rm=T)

llijst$g<-ifelse(llijst$max <= 9,9,
                 ifelse(llijst$max <= 99,99,
                        ifelse(llijst$max <= 999,999,
                               ifelse(llijst$max <= 9999,9999,99999))))

splits<-split(llijst, llijst$g)
array.1<-as.vector(splits$`9`[,"var"])
array.2<-as.vector(splits$`99`[,"var"])
array.3<-as.vector(splits$`999`[,"var"])
array.4<-as.vector(splits$`9999`[,"var"])
array.5<-as.vector(splits$`99999`[,"var"])
array.all<-c(array.1,array.2,array.3,array.4,array.5)


respondents<-MF

respondents[array.1]<-lapply(respondents[array.1],NA1)
respondents[array.2]<-lapply(respondents[array.2],NA2)
respondents[array.3]<-lapply(respondents[array.3],NA3)
respondents[array.4]<-lapply(respondents[array.4],NA4)
respondents[array.5]<-lapply(respondents[array.5],NA5)

respondents$t0<-apply(respondents[array.all],1, fun.0)
respondents$t1<-apply(respondents[array.all],1, fun.1)
respondents$t2<-apply(respondents[array.all],1, fun.2)
respondents$t3<-apply(respondents[array.all],1, fun.3)
respondents$t4<-apply(respondents[array.all],1, fun.4)
respondents$tt<-respondents$t0+respondents$t1+respondents$t2+respondents$t3+respondents$t4#total numner pf question
respondents$q.elig<-respondents$tt-respondents$t1
respondents$perc.unanswerd<-(respondents$t2+respondents$t3+respondents$t4)/(respondents$tt-respondents$t1)
respondents<-respondents[,c("ID.IND","q.elig","perc.unanswerd")]
min(respondents$q.elig)

MF<-merge(MF,respondents,by="ID.IND")
MF$q.eligC<-MF$q.elig
MF$speedC<-MF$q.eligC/MF$CINWTM
min(MF$q.eligC,na.rm=T)
max(MF$q.eligC,na.rm=T)
MF<-MF[, which(!names(MF) %in% c("q.elig"))]

MF$lspeedC<-log(MF$speedC)
#module D

attach(MF)
lijst<-NULL

for(i in 1:length(array.D)){
  #  for(i in 1:3){
  var<-array.D[[i]]
  print(var) 
  t<-as.data.frame(table(get(var)))
  t$var<-var
  lijst<-rbind(lijst,t)}
detach(MF)
lijst$Freq<-as.numeric(as.character(lijst$Var1))
llijst<-dcast(lijst, var ~ Var1, mean, value.var = 'Freq')
llijst$max <- apply(llijst[,-1],1,max,na.rm=T)

llijst$g<-ifelse(llijst$max <= 9,9,
                 ifelse(llijst$max <= 99,99,
                        ifelse(llijst$max <= 999,999,
                               ifelse(llijst$max <= 9999,9999,99999))))

splits<-split(llijst, llijst$g)
array.1<-as.vector(splits$`9`[,"var"])
array.2<-as.vector(splits$`99`[,"var"])
array.3<-as.vector(splits$`999`[,"var"])
array.4<-as.vector(splits$`9999`[,"var"])
array.5<-as.vector(splits$`99999`[,"var"])
array.all<-c(array.1,array.2,array.3,array.4,array.5)


respondents<-MF

respondents[array.1]<-lapply(respondents[array.1],NA1)
respondents[array.2]<-lapply(respondents[array.2],NA2)
respondents[array.3]<-lapply(respondents[array.3],NA3)
respondents[array.4]<-lapply(respondents[array.4],NA4)
respondents[array.5]<-lapply(respondents[array.5],NA5)

respondents$t0<-apply(respondents[array.all],1, fun.0)
respondents$t1<-apply(respondents[array.all],1, fun.1)
respondents$t2<-apply(respondents[array.all],1, fun.2)
respondents$t3<-apply(respondents[array.all],1, fun.3)
respondents$t4<-apply(respondents[array.all],1, fun.4)
respondents$tt<-respondents$t0+respondents$t1+respondents$t2+respondents$t3+respondents$t4#total numner pf question
respondents$q.elig<-respondents$tt-respondents$t1
respondents$perc.unanswerd<-(respondents$t2+respondents$t3+respondents$t4)/(respondents$tt-respondents$t1)
respondents<-respondents[,c("ID.IND","q.elig","perc.unanswerd")]
min(respondents$q.elig)

MF<-merge(MF,respondents,by="ID.IND")
MF$q.eligD<-MF$q.elig
MF$speedD<-MF$q.eligD/MF$DINWTM
min(MF$q.eligD,na.rm=T)
max(MF$q.eligD,na.rm=T)
MF<-MF[, which(!names(MF) %in% c("q.elig"))]

MF$lspeedD<-log(MF$speedD)
#module E

attach(MF)
lijst<-NULL

for(i in 1:length(array.E)){
  #  for(i in 1:3){
  var<-array.E[[i]]
  print(var) 
  t<-as.data.frame(table(get(var)))
  t$var<-var
  lijst<-rbind(lijst,t)}
detach(MF)
lijst$Freq<-as.numeric(as.character(lijst$Var1))
llijst<-dcast(lijst, var ~ Var1, mean, value.var = 'Freq')
llijst$max <- apply(llijst[,-1],1,max,na.rm=T)

llijst$g<-ifelse(llijst$max <= 9,9,
                 ifelse(llijst$max <= 99,99,
                        ifelse(llijst$max <= 999,999,
                               ifelse(llijst$max <= 9999,9999,99999))))

splits<-split(llijst, llijst$g)
array.1<-as.vector(splits$`9`[,"var"])
array.2<-as.vector(splits$`99`[,"var"])
array.3<-as.vector(splits$`999`[,"var"])
array.4<-as.vector(splits$`9999`[,"var"])
array.5<-as.vector(splits$`99999`[,"var"])
array.all<-c(array.1,array.2,array.3,array.4,array.5)


respondents<-MF

respondents[array.1]<-lapply(respondents[array.1],NA1)
respondents[array.2]<-lapply(respondents[array.2],NA2)
respondents[array.3]<-lapply(respondents[array.3],NA3)
respondents[array.4]<-lapply(respondents[array.4],NA4)
respondents[array.5]<-lapply(respondents[array.5],NA5)

respondents$t0<-apply(respondents[array.all],1, fun.0)
respondents$t1<-apply(respondents[array.all],1, fun.1)
respondents$t2<-apply(respondents[array.all],1, fun.2)
respondents$t3<-apply(respondents[array.all],1, fun.3)
respondents$t4<-apply(respondents[array.all],1, fun.4)
respondents$tt<-respondents$t0+respondents$t1+respondents$t2+respondents$t3+respondents$t4#total numner pf question
respondents$q.elig<-respondents$tt-respondents$t1
respondents$perc.unanswerd<-(respondents$t2+respondents$t3+respondents$t4)/(respondents$tt-respondents$t1)
respondents<-respondents[,c("ID.IND","q.elig","perc.unanswerd")]
min(respondents$q.elig)

MF<-merge(MF,respondents,by="ID.IND")
MF$q.eligE<-MF$q.elig
MF$speedE<-MF$q.eligE/MF$EINWTM
min(MF$speedE,na.rm=T)
MF<-MF[, which(!names(MF) %in% c("q.elig"))]
min(MF$q.eligE,na.rm=T)
max(MF$q.eligE,na.rm=T)
MF$lspeedE<-log(MF$speedE)

aggregate(MF$speedB,by=list(MF$CNTRY),FUN=mean,na.rm=T)
aggregate(MF$speedB,by=list(MF$CNTRY),FUN=sd,na.rm=T)
aggregate(MF$speedC,by=list(MF$CNTRY),FUN=mean,na.rm=T)
aggregate(MF$speedC,by=list(MF$CNTRY),FUN=sd,na.rm=T)
aggregate(MF$speedD,by=list(MF$CNTRY),FUN=mean,na.rm=T)
aggregate(MF$speedD,by=list(MF$CNTRY),FUN=sd,na.rm=T)
aggregate(MF$speedE,by=list(MF$CNTRY),FUN=mean,na.rm=T)
aggregate(MF$speedE,by=list(MF$CNTRY),FUN=sd,na.rm=T)

##############prepare explanatory variables
IN<-IN7[which(IN7$CNTRY %in% c("AT","BE","DK","EE","FI","FR","HU","IE","DE","NL","NO","SI","SE","CH","GB")),]
IN$ID.IND<-paste("I",IN$CNTRY,IN$ESSROUND*100000000+IN$IDNO,sep="")
IN$ID.INT<-paste("I",IN$CNTRY,IN$ESSROUND*100000000+IN$INTNUM,sep="")
MF<-merge(MF,IN[,c("ID.IND","ID.INT","INTLNGA")],by="ID.IND")

MF$LANG.mis<-ifelse(MF$LNGHOM1 %in% c("777","888","999") | is.na(MF$LNGHOM1),1,0)
MF$LANG.SAME1<-NA
MF$LANG.SAME1<-ifelse((as.character(MF$LNGHOM1)==as.character(MF$INTLNGA)),1,0)
MF$LANG.SAME2<-(as.character(MF$LNGHOM1)==as.character(MF$INTLNGA) | 
                  as.character(MF$LNGHOM2)==as.character(MF$INTLNGA))
MF$LANG.SAME1<-ifelse(MF$LANG.mis==1,NA,MF$LANG.SAME1)
MF$LANG.SAME2<-ifelse(MF$LANG.mis==1,NA,MF$LANG.SAME2)
MF$opl<-ifelse(MF$EISCED %in% c(1,2,3,4,5,6,7),MF$EISCED,NA)
MF$opl1<-ifelse(MF$opl %in% c(1,2),1,0)
MF$opl2<-ifelse(MF$opl %in% c(3,4,5),1,0)
MF$opl3<-ifelse(MF$opl %in% c(6,7),1,0)
MF$lft<-ifelse(MF$AGEA > 105,NA, MF$AGEA-30)
MF$sexe<-ifelse(MF$GNDR > 2,NA, MF$GNDR)
MF$dens<-ifelse(MF$DOMICIL > 6,NA, MF$DOMICIL)
MF$health<-ifelse(MF$HEALTH > 5,NA, MF$HEALTH)
###################################ADD REGION and Density###################
MF$dens<-ifelse(MF$DOMICIL > 6,NA, MF$DOMICIL)

table(MF$REGAT11)

#binary variables for regions
#AT
MF$REGAT11<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT11 "),1,0))
MF$REGAT12<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT12 "),1,0))
MF$REGAT13<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT13 "),1,0))
MF$REGAT21<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT21 "),1,0))
MF$REGAT22<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT22 "),1,0))
MF$REGAT31<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT31 "),1,0))
MF$REGAT32<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT32 "),1,0))
MF$REGAT33<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT33 "),1,0))
MF$REGAT34<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("AT34 "),1,0))
#BE
MF$REGBE10<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE10 "),1,0))
MF$REGBE21<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE21 "),1,0))
MF$REGBE22<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE22 "),1,0))
MF$REGBE23<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE23 "),1,0))
MF$REGBE24<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE24 "),1,0))
MF$REGBE25<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE25 "),1,0))
MF$REGBE31<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE31 "),1,0))
MF$REGBE32<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE32 "),1,0))
MF$REGBE33<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE33 "),1,0))
MF$REGBE34<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE34 "),1,0))
MF$REGBE35<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("BE35 "),1,0))
#CH
MF$REGCH01<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH01 "),1,0))
MF$REGCH02<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH02 "),1,0))
MF$REGCH03<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH03 "),1,0))
MF$REGCHO5<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH04 "),1,0))
MF$REGCH06<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH05 "),1,0))
MF$REGCH07<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH06 "),1,0))
MF$REGCH08<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("CH07 "),1,0))
#DE
MF$REGDE1<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE1  "),1,0))
MF$REGDE2<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE2  "),1,0))
MF$REGDE3<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE3  "),1,0))
MF$REGDE4<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE4  "),1,0))
MF$REGDE5<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE5  "),1,0))
MF$REGDE6<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE6  "),1,0))
MF$REGDE7<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE7  "),1,0))
MF$REGDE8<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE8  "),1,0))
MF$REGDE9<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DE9  "),1,0))
MF$REGDEA<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DEA  "),1,0))
MF$REGDEB<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DEB  "),1,0))
MF$REGDEC<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DEC  "),1,0))
MF$REGDED<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DED  "),1,0))
MF$REGDEE<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DEE  "),1,0))
MF$REGDEF<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DEF  "),1,0))
MF$REGDEG<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DEG  "),1,0))
#DK
MF$REGDK1<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DK01 "),1,0))
MF$REGDK2<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DK02 "),1,0))
MF$REGDK3<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DK03 "),1,0))
MF$REGDK4<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DK04 "),1,0))
MF$REGDK5<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("DK05 "),1,0))
table(MF$REGDK1)
#EE
MF$REGEE01<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("EE001"),1,0))
MF$REGEE04<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("EE004"),1,0))
MF$REGEE06<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("EE006"),1,0))
MF$REGEE07<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("EE007"),1,0))
MF$REGEE08<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("EE008"),1,0))
#FI
MF$REGFI193<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI193"),1,0))
MF$REGFI194<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI194"),1,0))
MF$REGFI195<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI195"),1,0))
MF$REGFI196<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI196"),1,0))
MF$REGFI197<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI197"),1,0))
MF$REGFI1B1<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1B1"),1,0))
MF$REGFI1C1<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1C1"),1,0))
MF$REGFI1C2<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1C2"),1,0))
MF$REGFI1C3<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1C3"),1,0))
MF$REGFI1C4<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1C4"),1,0))
MF$REGFI1C5<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1C5"),1,0))
MF$REGFI1D1<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D1"),1,0))
MF$REGFI1D2<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D2"),1,0))
MF$REGFI1D3<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D3"),1,0))
MF$REGFI1D4<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D4"),1,0))
MF$REGFI1D5<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D5"),1,0))
MF$REGFI1D6<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D6"),1,0))
MF$REGFI1D7<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI1D7"),1,0))
MF$REGFI200<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FI200"),1,0))
#FR
MF$REGFR10<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR10 "),1,0))
MF$REGFR21<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR21 "),1,0))
MF$REGFR22<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR22 "),1,0))
MF$REGFR23<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR23 "),1,0))
MF$REGFR24<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR24 "),1,0))
MF$REGFR25<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR25 "),1,0))
MF$REGFR26<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR26 "),1,0))
MF$REGFR30<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR30 "),1,0))
MF$REGFR41<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR41 "),1,0))
MF$REGFR42<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR42 "),1,0))
MF$REGFR43<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR43 "),1,0))
MF$REGFR51<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR51 "),1,0))
MF$REGFR52<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR52 "),1,0))
MF$REGFR53<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR53 "),1,0))
MF$REGFR61<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR51 "),1,0))
MF$REGFR62<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR62 "),1,0))
MF$REGFR63<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR63 "),1,0))
MF$REGFR71<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR71 "),1,0))
MF$REGFR72<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR72 "),1,0))
MF$REGFR81<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR81 "),1,0))
MF$REGFR82<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("FR82 "),1,0))
table(MF[which(MF$CNTRY=="FR"),]$REGION)
#HU
MF$REGHU101<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU101"),1,0))
MF$REGHU102<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU102"),1,0))
MF$REGHU211<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU211"),1,0))
MF$REGHU212<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU212"),1,0))
MF$REGHU213<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU213"),1,0))
MF$REGHU221<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU221"),1,0))
MF$REGHU222<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU222"),1,0))
MF$REGHU223<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU223"),1,0))
MF$REGHU231<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU231"),1,0))
MF$REGHU232<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU232"),1,0))
MF$REGHU233<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU233"),1,0))
MF$REGHU311<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU311"),1,0))
MF$REGHU312<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU312"),1,0))
MF$REGHU313<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU313"),1,0))
MF$REGHU321<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU321"),1,0))
MF$REGHU322<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU322"),1,0))
MF$REGHU323<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU323"),1,0))
MF$REGHU331<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU331"),1,0))
MF$REGHU332<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU332"),1,0))
MF$REGHU333<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("HU333"),1,0))
#IE
MF$REGIE011<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE011"),1,0))
MF$REGIE012<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE012"),1,0))
MF$REGIE013<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE013"),1,0))
MF$REGIE021<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE021"),1,0))
MF$REGIE022<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE022"),1,0))
MF$REGIE023<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE023"),1,0))
MF$REGIE024<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("IE024"),1,0))
#NL
MF$REGNL11<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL11 "),1,0))
MF$REGNL12<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL12 "),1,0))
MF$REGNL13<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL13 "),1,0))
MF$REGNL21<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL21 "),1,0))
MF$REGNL22<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL22 "),1,0))
MF$REGNL23<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL23 "),1,0))
MF$REGNL31<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL31 "),1,0))
MF$REGNL32<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL32 "),1,0))
MF$REGNL33<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL33 "),1,0))
MF$REGNL34<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL34 "),1,0))
MF$REGNL41<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL41 "),1,0))
MF$REGNL42<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NL42 "),1,0))
#NO
MF$REGNO001<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO01 "),1,0))
MF$REGNO002<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO02 "),1,0))
MF$REGNO003<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO03 "),1,0))
MF$REGNO004<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO04 "),1,0))
MF$REGNO005<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO05 "),1,0))
MF$REGNO006<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO06 "),1,0))
MF$REGNO007<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("NO07 "),1,0))
table(MF$REGNO001)
#SE
MF$REGSE110<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE110"),1,0))
MF$REGSE121<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE121"),1,0))
MF$REGSE122<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE122"),1,0))
MF$REGSE123<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE123"),1,0))
MF$REGSE124<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE124"),1,0))
MF$REGSE125<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE125"),1,0))
MF$REGSE211<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE211"),1,0))
MF$REGSE212<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE212"),1,0))
MF$REGSE213<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE213"),1,0))
MF$REGSE214<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE214"),1,0))
MF$REGSE221<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE221"),1,0))
MF$REGSE224<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE224"),1,0))
MF$REGSE231<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE231"),1,0))
MF$REGSE232<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE232"),1,0))
MF$REGSE311<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE311"),1,0))
MF$REGSE312<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE312"),1,0))
MF$REGSE313<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE313"),1,0))
MF$REGSE321<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE321"),1,0))
MF$REGSE322<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE322"),1,0))
MF$REGSE331<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE331"),1,0))
MF$REGSE332<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SE332"),1,0))
#SI
MF$REGSI011<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI011"),1,0))
MF$REGSI012<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI012"),1,0))
MF$REGSI013<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI013"),1,0))
MF$REGSI014<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI014"),1,0))
MF$REGSI015<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI015"),1,0))
MF$REGSI016<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI016"),1,0))
MF$REGSI017<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI017"),1,0))
MF$REGSI018<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI018"),1,0))
MF$REGSI021<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI021"),1,0))
MF$REGSI022<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI022"),1,0))
MF$REGSI023<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI023"),1,0))
MF$REGSI024<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("SI024"),1,0))
#UK
MF$REGUKC<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKC  "),1,0))
MF$REGUKD<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKD  "),1,0))
MF$REGUKE<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKE  "),1,0))
MF$REGUKF<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKF  "),1,0))
MF$REGUKG<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKG  "),1,0))
MF$REGUKH<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKH  "),1,0))
MF$REGUKI<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKI  "),1,0))
MF$REGUKJ<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKJ  "),1,0))
MF$REGUKK<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKK  "),1,0))
MF$REGUKL<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKL  "),1,0))
MF$REGUKM<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKM  "),1,0))
MF$REGUKN<-ifelse(MF$REGION==99999,NA, ifelse(MF$REGION %in% c("UKN  "),1,0))

MF$TIJD<-julian(as.Date(paste(MF$INWYYS,MF$INWMMS,MF$INWDDS,sep="-")))+
  (60*MF$INWSHH+MF$INWSMM)/(60)-  julian(as.Date(paste("2014","01","01",sep="-")))
MF<-MF[order(MF$ID.INT,MF$TIJD),] 
RESPONDENTSa<-MF[!is.na(MF$TIJD),c("ID.IND","ID.INT", "TIJD")]
RESPONDENTSb<-MF[is.na(MF$TIJD),c("ID.IND","ID.INT", "TIJD")]
RESPONDENTSa$RANK<-unlist(with(RESPONDENTSa, tapply(TIJD, ID.INT, function(x) rank(x,ties.method = "first"))))
RESPONDENTSb$RANK<-NA
RESPONDENTS<-rbind(RESPONDENTSa,RESPONDENTSb)
table(MF$RANK)
MF<-merge(MF,RESPONDENTS[,c("ID.IND","RANK")], by="ID.IND")
table(MF$RANK)
MF$RANK<-MF$RANK-1
landen<-as.data.frame(table(MF$CNTRY))
rm(SpeedE, SpeedD,SpeedC, SpeedD, speed)
#ANOVA analysis
SpeedB<-MF[, c("CNTRY","speedB")]
SpeedB$mod<-"B"
colnames(SpeedB)<-c("CNTRY", "Speed","mod")
SpeedC<-MF[, c("CNTRY","speedC")]
SpeedC$mod<-"C"
colnames(SpeedC)<-c("CNTRY", "Speed","mod")
SpeedD<-MF[, c("CNTRY","speedD")]
SpeedD$mod<-"D"
colnames(SpeedD)<-c("CNTRY", "Speed","mod")
SpeedE<-MF[, c("CNTRY","speedE")]
SpeedE$mod<-"E"
colnames(SpeedE)<-c("CNTRY", "Speed","mod")
speed<-rbind(SpeedB, SpeedC, SpeedD, SpeedE)
table(speed$mod)
anova<-aov(Speed~CNTRY*mod,speed)
summary(anova)
##############speed style################
MF1<-MF
landen<-as.data.frame(table(MF1$CNTRY))
MF1$lspeedB

#####Speed module A to E#######


#MF1$speedAE<-(5+MF1$q.eligB+MF1$q.eligC+MF1$q.eligD+MF1$q.eligE)/(MF1$AINWTM+MF1$BINWTM+MF1$CINWTM+MF1$DINWTM+MF1$EINWTM)
#table(is.na(MF1[which(MF1$CNTRY=="GB"),]$REGUKD))


#MFdeel<-MF1[which(MF1$CNTRY==landen[1,1]&!is.na(MF1$speedAE)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$REGION)&!is.na(MF1$dens)),]
#fitspeed<-lm(speedAE~RANK+lft+opl2+opl3+sexe+LANG.SAME1+dens+
#    REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
#              REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08
#            , data= MF1[which(MF1$CNTRY==landen[1,1]),])
#MFdeel$resspeed<-residuals(fitspeed)
#MFdeel<-MFdeel[,c("ID.IND","resspeed")]

#for(l in 2:nrow(landen)){
 # MFdeel1<-MF1[which(MF1$CNTRY==landen[l,1]&!is.na(MF1$speedAE)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$REGUKD)&!is.na(MF1$dens)),]
  #fitspeed<-lm(speedAE~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
#               +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
 
#                REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
 
#                REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
#                REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
#                REGDED+REGDEE+REGDEF+REGDEG+
#                REGDK2+REGDK3+REGDK4+REGDK5+
#                REGEE01+REGEE04++REGEE07+REGEE08+
#                REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
#                +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
#                REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
#                REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
#                REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
#                REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
#                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
#                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
#                REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
#                REGSI023+REGSI024
#              +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN
#              , data= MFdeel1)
# MFdeel1$resspeed<-residuals(fitspeed)
# print(landen[l,1])
# MFdeel1<-MFdeel1[,c("ID.IND","resspeed")]
# MFdeel<-rbind(MFdeel,MFdeel1)
#}
#MF1<-merge(MF1,MFdeel, by="ID.IND")

#meanspeedres<-aggregate(MF1$resspeed,by=list(MF1$CNTRY),mean,na.rm=T)
#SDspeedres<-aggregate(MF1$resspeed,by=list(MF1$CNTRY),sd,na.rm=T)
#names(meanspeedres)<-c("CNTRY","meanspeed")
#names(SDspeedres)<-c("CNTRY","SDspeed")
#MF1<-merge(MF1,meanspeedres, by="CNTRY")
#MF1<-merge(MF1,SDspeedres, by="CNTRY")
#MF1$speedpos<-ifelse(MF1$resspeed>MF1$meanspeed+MF1$SDspeed,1,ifelse(MF1$resspeed<MF1$meanspeed-MF1$SDspeed,-1,0))

#table(MF1$CNTRY,MF1$speedpos)
##delete entries with only one respodnent per interviewer
#MFint<-aggregate(MF1$IDNO, by=list(MF1$CNTRY,MF1$ID.INT,MF1$speedpos),FUN=length)
#MFint2<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
#MFint$onlyone<-ifelse(MFint$x %in% c(1,2),0, 1)
#names(MFint)<-c("CNTRY","ID.INT","speedpos","resp_int","onlyone")
#MFall<- merge(MF1, MFint, by=c("CNTRY","ID.INT","speedpos"))
#MFall<-MFall[which(MFall$onlyone==1),]
#table(MFall$CNTRY,MFall$speedpos)
#MFint<-aggregate(MFall$IDNO, by=list(MFall$CNTRY,MFall$ID.INT,MFall$speedpos),FUN=length)
#MFint2<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
#min(MFint2$x)
#########Speed module B####

MF1<-MF
MFdeel<-MF1[which(MF1$CNTRY==landen[1,1]&!is.na(MF1$speedB)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)),]
fitspeed<-lm(lspeedB~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
             +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
               REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
               REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
               REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
               REGDED+REGDEE+REGDEF+REGDEG+
               REGDK2+REGDK3+REGDK4+REGDK5+
               REGEE01+REGEE04++REGEE07+REGEE08+
               REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
               +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
               REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
               REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
               REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
               REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
               REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
               REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
               REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
               REGSI023+REGSI024
             +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[1,1]),])
MFdeel$resspeedB<-residuals(fitspeed)
MFdeel<-MFdeel[,c("ID.IND","resspeedB")]
summary(fitspeed)$adj.r.squared

for(l in 2:nrow(landen)){
  MFdeel1<-MF1[which(MF1$CNTRY==landen[l,1]&!is.na(MF1$speedB)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
  fitspeed<-lm(lspeedB~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
               +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[l,1]),])
  MFdeel1$resspeedB<-residuals(fitspeed)
  print(summary(fitspeed)$adj.r.squared)
  print(landen[l,1])
  MFdeel1<-MFdeel1[,c("ID.IND","resspeedB")]
  MFdeel<-rbind(MFdeel,MFdeel1)
}
MF1<-merge(MF1,MFdeel, by="ID.IND")

meanspeedresB<-aggregate(MF1$resspeedB,by=list(MF1$CNTRY),mean,na.rm=T)
SDspeedresB<-aggregate(MF1$resspeedB,by=list(MF1$CNTRY),sd,na.rm=T)
names(meanspeedresB)<-c("CNTRY","meanspeedB")
names(SDspeedresB)<-c("CNTRY","SDspeedB")
MF1<-merge(MF1,meanspeedresB, by="CNTRY")
MF1<-merge(MF1,SDspeedresB, by="CNTRY")
MF1$speedposB<-ifelse(MF1$resspeedB>MF1$meanspeedB+MF1$SDspeedB,1,ifelse(MF1$resspeedB<MF1$meanspeedB-MF1$SDspeedB,-1,0))

table(MF1$CNTRY,MF1$speedposB)
MFint<-aggregate(MF1$IDNO, by=list(MF1$CNTRY,MF1$ID.INT,MF1$speedposB),FUN=length)
MFint2<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
MFint$onlyone<-ifelse(MFint$x %in% c(1,2),0, 1)
names(MFint)<-c("CNTRY","ID.INT","speedposB","resp_int","onlyone")
MFB<- merge(MF1, MFint, by=c("CNTRY","ID.INT","speedposB"))
table(MFB$onlyone)
MFB<-MFB[which(MFB$onlyone==1),]
table(MFB$CNTRY,MFB$speedposB)
#how many cases per interviewer per country per type
MFint<-aggregate(MFB$IDNO, by=list(MFB$CNTRY,MFB$ID.INT,MFB$speedpos),FUN=length)
MFintB<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
MFRESB<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = sum )
#MFspeedposB<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.2), FUN = length )
#table(MFspeedposB$Group.1,MFspeedposB$x)
#table(MFspeedposB$Group.1)

#########Speed module C####
MF1<-MF
MFdeel<-MF1[which(MF1$CNTRY==landen[1,1]&!is.na(MF1$speedC)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
fitspeed<-lm(lspeedC~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
             +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
               REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
               REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
               REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
               REGDED+REGDEE+REGDEF+REGDEG+
               REGDK2+REGDK3+REGDK4+REGDK5+
               REGEE01+REGEE04++REGEE07+REGEE08+
               REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
               +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
               REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
               REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
               REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
               REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
               REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
               REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
               REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
               REGSI023+REGSI024
             +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[1,1]),])
MFdeel$resspeedC<-residuals(fitspeed)
MFdeel<-MFdeel[,c("ID.IND","resspeedC")]
print(summary(fitspeed)$adj.r.squared)
for(l in 2:nrow(landen)){
  MFdeel1<-MF1[which(MF1$CNTRY==landen[l,1]&!is.na(MF1$lspeedC)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$opl3)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
  fitspeed<-lm(lspeedC~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
               +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[l,1]),])
  MFdeel1$resspeedC<-residuals(fitspeed)
  print(landen[l,1])
  print(summary(fitspeed)$adj.r.squared)
  MFdeel1<-MFdeel1[,c("ID.IND","resspeedC")]
  MFdeel<-rbind(MFdeel,MFdeel1)
}
MF1<-merge(MF1,MFdeel, by="ID.IND")

meanspeedresC<-aggregate(MF1$resspeedC,by=list(MF1$CNTRY),mean,na.rm=T)
SDspeedresC<-aggregate(MF1$resspeedC,by=list(MF1$CNTRY),sd,na.rm=T)
names(meanspeedresC)<-c("CNTRY","meanspeedC")
names(SDspeedresC)<-c("CNTRY","SDspeedC")
MF1<-merge(MF1,meanspeedresC, by="CNTRY")
MF1<-merge(MF1,SDspeedresC, by="CNTRY")
MF1$speedposC<-ifelse(MF1$resspeedC>MF1$meanspeedC+MF1$SDspeedC,1,ifelse(MF1$resspeedC<MF1$meanspeedC-MF1$SDspeedC,-1,0))

table(MF1$CNTRY,MF1$speedposC)
MFint<-aggregate(MF1$IDNO, by=list(MF1$CNTRY,MF1$ID.INT,MF1$speedposC),FUN=length)
MFint2<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
MFint$onlyone<-ifelse(MFint$x %in% c(1,2),0, 1)
names(MFint)<-c("CNTRY","ID.INT","speedposC","resp_int","onlyone")
MFC<- merge(MF1, MFint, by=c("CNTRY","ID.INT","speedposC"))
MFC<-MFC[which(MFC$onlyone==1),]
table(MFC$CNTRY,MFC$speedposC)
MFint<-aggregate(MFC$IDNO, by=list(MFC$CNTRY,MFC$ID.INT,MFC$speedposC),FUN=length)
MFintC<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )


#########Speed module D####
MF1<-MF

MFdeel<-MF1[which(MF1$CNTRY==landen[1,1]&!is.na(MF1$speedD)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
fitspeed<-lm(lspeedD~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
             +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
               REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
               REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
               REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
               REGDED+REGDEE+REGDEF+REGDEG+
               REGDK2+REGDK3+REGDK4+REGDK5+
               REGEE01+REGEE04++REGEE07+REGEE08+
               REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
               +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
               REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
               REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
               REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
               REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
               REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
               REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
               REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
               REGSI023+REGSI024
             +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[1,1]),])
MFdeel$resspeedD<-residuals(fitspeed)
MFdeel<-MFdeel[,c("ID.IND","resspeedD")]
print(summary(fitspeed)$adj.r.squared)
for(l in 2:nrow(landen)){
  MFdeel1<-MF1[which(MF1$CNTRY==landen[l,1]&!is.na(MF1$speedD)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
  fitspeed<-lm(lspeedD~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
               +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[l,1]),])
  MFdeel1$resspeedD<-residuals(fitspeed)
  print(landen[l,1])
  print(summary(fitspeed)$adj.r.squared)
  MFdeel1<-MFdeel1[,c("ID.IND","resspeedD")]
  MFdeel<-rbind(MFdeel,MFdeel1)
}
MF1<-merge(MF1,MFdeel, by="ID.IND")

meanspeedresD<-aggregate(MF1$resspeedD,by=list(MF1$CNTRY),mean,na.rm=T)
SDspeedresD<-aggregate(MF1$resspeedD,by=list(MF1$CNTRY),sd,na.rm=T)
names(meanspeedresD)<-c("CNTRY","meanspeedD")
names(SDspeedresD)<-c("CNTRY","SDspeedD")
MF1<-merge(MF1,meanspeedresD, by="CNTRY")
MF1<-merge(MF1,SDspeedresD, by="CNTRY")
MF1$speedposD<-ifelse(MF1$resspeedD>MF1$meanspeedD+MF1$SDspeedD,1,ifelse(MF1$resspeedD<MF1$meanspeedD-MF1$SDspeedD,-1,0))

table(MF1$CNTRY,MF1$speedposD)
MFint<-aggregate(MF1$IDNO, by=list(MF1$CNTRY,MF1$ID.INT,MF1$speedposD),FUN=length)
MFint2<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
MFint$onlyone<-ifelse(MFint$x %in% c(1,2),0, 1)
names(MFint)<-c("CNTRY","ID.INT","speedposD","resp_int","onlyone")
MFD<- merge(MF1, MFint, by=c("CNTRY","ID.INT","speedposD"))
MFD<-MFD[which(MFD$onlyone==1),]
table(MFD$CNTRY,MFD$speedposD)
MFint<-aggregate(MFD$IDNO, by=list(MFD$CNTRY,MFD$ID.INT,MFD$speedposD),FUN=length)
MFintD<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )


#########Speed module E####
MF1<-MF

MFdeel<-MF1[which(MF1$CNTRY==landen[1,1]&!is.na(MF1$speedE)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
fitspeed<-lm(lspeedE~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
             +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
               REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
               REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
               REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
               REGDED+REGDEE+REGDEF+REGDEG+
               REGDK2+REGDK3+REGDK4+REGDK5+
               REGEE01+REGEE04++REGEE07+REGEE08+
               REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
               +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
               REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
               REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
               REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
               REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
               REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
               REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
               REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
               REGSI023+REGSI024
             +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[1,1]),])
MFdeel$resspeedE<-residuals(fitspeed)
MFdeel<-MFdeel[,c("ID.IND","resspeedE")]
print(summary(fitspeed)$adj.r.squared)
for(l in 2:nrow(landen)){
  MFdeel1<-MF1[which(MF1$CNTRY==landen[l,1]&!is.na(MF1$speedE)&!is.na(MF1$RANK)&!is.na(MF1$lft)&!is.na(MF1$opl2)&!is.na(MF1$sexe)&!is.na(MF1$LANG.SAME1)&!is.na(MF1$dens)&!is.na(MF1$REGUKD)),]
  fitspeed<-lm(lspeedE~RANK+ I(RANK^2)+lft+I(lft^2)+ opl2+opl3+opl2*lft+opl3*lft+sexe+sexe*lft+sexe*opl2+sexe*opl3
               +LANG.SAME1+LANG.SAME1*sexe+LANG.SAME1*opl2+LANG.SAME1*opl3+LANG.SAME1*lft+dens+
                 REGAT11+REGAT12+REGAT13+REGAT21+REGAT22+REGAT31+REGAT32+REGAT33+
                 REGBE21+REGBE22+REGBE23+REGBE24+REGBE25+REGBE31+REGBE32+REGBE33+REGBE34+REGBE35+  REGCH02+REGCH03+REGCHO5+REGCH06+REGCH07+REGCH08+
                 REGDE2+REGDE3+REGDE4+REGDE5+REGDE6+REGDE7+REGDE8+REGDE9+REGDEA+REGDEB+REGDEC+
                 REGDED+REGDEE+REGDEF+REGDEG+
                 REGDK2+REGDK3+REGDK4+REGDK5+
                 REGEE01+REGEE04++REGEE07+REGEE08+
                 REGFI193+REGFI194+REGFI195+REGFI196+REGFI197+REGFI1B1+REGFI1C1+REGFI1C2+REGFI1C3+ REGFI1C4+REGFI1C5+REGFI1D1+REGFI1D2+REGFI1D3+REGFI1D4+REGFI1D5+REGFI1D6+REGFI1D7+  REGFI200+   REGFR21+REGFR22+REGFR23+REGFR24+REGFR25+REGFR26+REGFR30+REGFR41+REGFR42+REGFR43+  REGFR51+REGFR52+REGFR53+REGFR61+REGFR62+REGFR63+REGFR71+REGFR72+REGFR81+REGFR82+      
                 +REGHU102+REGHU211-REGHU212+REGHU213+REGHU221+REGHU222+REGHU223+REGHU231+
                 REGHU232+REGHU233+REGHU311+REGHU312+REGHU313+REGHU321+REGHU322+REGHU323+  REGHU331+REGHU332+REGHU333+
                 REGIE012+REGIE013+REGIE021+REGIE022+REGIE023+REGIE024+
                 REGNL12+REGNL13+REGNL21+REGNL22+REGNL23+REGNL31+REGNL32+REGNL33+REGNL34+     REGNL41+REGNL42+
                 REGNO002+REGNO003+REGNO004+REGNO005+REGNO006+REGNO007+
                 REGSE121+REGSE122+REGSE123+REGSE124+REGSE125+REGSE211+REGSE212+REGSE213+
                 REGSE214+REGSE221+REGSE224+REGSE231+REGSE232+REGSE311+REGSE312+REGSE313+REGSE321+REGSE322+REGSE331+REGSE332+
                 REGSI012+REGSI013+REGSI014+REGSI015+REGSI016+REGSI017+REGSI018+REGSI021+REGSI022+
                 REGSI023+REGSI024
               +REGUKD+REGUKE+REGUKF+REGUKG+REGUKH+REGUKI+REGUKJ+REGUKK+REGUKL+REGUKM+  REGUKN, data= MF1[which(MF1$CNTRY==landen[l,1]),])
  MFdeel1$resspeedE<-residuals(fitspeed)
  print(summary(fitspeed)$adj.r.squared)
  print(landen[l,1])
  MFdeel1<-MFdeel1[,c("ID.IND","resspeedE")]
  MFdeel<-rbind(MFdeel,MFdeel1)
}
MF1<-merge(MF1,MFdeel, by="ID.IND")

meanspeedresE<-aggregate(MF1$resspeedE,by=list(MF1$CNTRY),mean,na.rm=T)
SDspeedresE<-aggregate(MF1$resspeedE,by=list(MF1$CNTRY),sd,na.rm=T)
names(meanspeedresE)<-c("CNTRY","meanspeedE")
names(SDspeedresE)<-c("CNTRY","SDspeedE")
MF1<-merge(MF1,meanspeedresE, by="CNTRY")
MF1<-merge(MF1,SDspeedresE, by="CNTRY")
MF1$speedposE<-ifelse(MF1$resspeedE>MF1$meanspeedE+MF1$SDspeedE,1,ifelse(MF1$resspeedE<MF1$meanspeedE-MF1$SDspeedE,-1,0))

table(MF1$CNTRY,MF1$speedposE)
MFint<-aggregate(MF1$IDNO, by=list(MF1$CNTRY,MF1$ID.INT,MF1$speedposE),FUN=length)
MFint2<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )
MFint$onlyone<-ifelse(MFint$x %in% c(1,2),0, 1)
names(MFint)<-c("CNTRY","ID.INT","speedposE","resp_int","onlyone")
MFE<- merge(MF1, MFint, by=c("CNTRY","ID.INT","speedposE"))
MFE<-MFE[which(MFE$onlyone==1),]
table(MFE$CNTRY,MFE$speedposE)
MFint<-aggregate(MFE$IDNO, by=list(MFE$CNTRY,MFE$ID.INT,MFE$speedposE),FUN=length)
MFintE<-aggregate(MFint$x, by=list(MFint$Group.1,MFint$Group.3), FUN = length )

#write.csv(MF,file="C:/Users/u0043958/Documents/PhD project/04-IE op lengten and answer content/MFn.csv")
write.csv(MFB,file="C:/Users/u0043958/Documents/PhD project/04-IE op lengten and answer content/MFBn.csv")
write.csv(MFC,file="C:/Users/u0043958/Documents/PhD project/04-IE op lengten and answer content/MFCn.csv")
write.csv(MFD,file="C:/Users/u0043958/Documents/PhD project/04-IE op lengten and answer content/MFDn.csv")
write.csv(MFE,file="C:/Users/u0043958/Documents/PhD project/04-IE op lengten and answer content/MFEn.csv")
